#!/bin/sh

# THIS PRODUCT CONTAINS RESTRICTED MATERIALS OF IBM
# IBM Confidential OCO Source Material
# 5639-D57, 5630-A36, 5630-A37, 5724-D18 (C) COPYRIGHT International Business Machines Corp., 1997,2002
# The source code for this program is not published or otherwise divested
# of its trade secrets, irrespective of what has been deposited with the
# U.S. Copyright Office.
# All Rights Reserved * Licensed Materials - Property of IBM
# US Government Users Restricted Rights - Use, duplication or disclosure
# restricted by GSA ADP Schedule Contract with IBM Corp.

# Server Stop Tool

# Launch Arguments:
#
# serverName - the name of the server process to be stopped.
# -nowait 
# -quiet 
# -trace 
# -timeout <seconds>
# -statusport <portnumber>
# -conntype <connector type>
# -port <portnumber>
# -username <name>
# -password <password>
# -help
# -?
#

# Bootstrap values ...
SHELL=com.ibm.ws.management.tools.WsServerStop 

binDir=`dirname $0`
. $binDir/setupCmdLine.sh

# For debugging the launcher itself
# DEBUG="-Djava.compiler=NONE -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=7777"

# Setup the initial java invocation;
PLATFORM=`/bin/uname`
case $PLATFORM in
  AIX)
    LIBPATH="$WAS_LIBPATH":$LIBPATH
    export LIBPATH ;;
  Linux)
    LD_LIBRARY_PATH="$WAS_LIBPATH":$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH ;;
  SunOS)
    LD_LIBRARY_PATH="$WAS_LIBPATH":$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH ;;
  HP-UX)
    SHLIB_PATH="$WAS_LIBPATH":$SHLIB_PATH
    export SHLIB_PATH ;;
esac

"$JAVA_HOME"/bin/java \
  -Xbootclasspath/p:"$WAS_BOOTCLASSPATH" \
  $DEBUG \
  "$CLIENTSAS" \
  "$CLIENTSOAP" \
  -Dws.ext.dirs="$WAS_EXT_DIRS" \
  -classpath "$WAS_CLASSPATH" \
  -Dwas.install.root="$WAS_HOME" \
  $USER_INSTALL_PROP \
  com.ibm.ws.bootstrap.WSLauncher \
  $SHELL "$CONFIG_ROOT" "$WAS_CELL" "$WAS_NODE" "$@"
